'''
iTunes Library Parser
- Author: Mathias Beke - http://denbeke.be
- Created: 7-3-2013
'''

from xml.dom.minidom import parse, parseString
import xml.etree.ElementTree as ElementTree


class Track:
	'''Class representing a song with a trackname, artist, album, year, genre'''
	
	def __init__(self, input_trackname, input_artist, input_albumArtist, input_album, input_year, input_genre):
		'''Creates new iTunes Song with given trackname, artist, album, year and genre'''
		self.trackname = input_trackname
		self.artist = input_artist
		self.albumArtist = input_albumArtist
		self.album = input_album
		self.year = input_year
		self.genre = input_genre
		
	def getTrackname(self):
		'''Returns the trackname'''
		return self.trackname
	
	def getArtist(self):
		'''Returns the artist'''
		return self.artist
		
	def getAlbumArtist(self):
		'''Returns the album artist'''
		return self.albumArtist
	
	def getAlbum(self):
		'''Returns the album'''
		return self.album
	
	def getYear(self):
		'''Returns the year'''
		return self.year
		
	def getGenre(self):
		'''Returns the genre'''
		return self.genre
		
	def __str__(self):
		'''Returns string of track'''
		return "Title: "+str(self.trackname)+", Artist: "+str(self.artist)+", Album: "+str(self.album)+", Year: "+str(self.year)+", Genre: "+str(self.genre)
		   

class iTunesParser:
	'''Class for parsing an iTunes Library'''
	
	def __init__(self, input_file):
		'''Constructor'''
		self.source = input_file #Source file
		self.xml = ElementTree.parse(input_file) # Parsed XML File in a tree
		self.library = list() #List containing all the tracks

	
	def parse(self):
		'''Parse the file'''
		# Documentation about Element Tree ->  http://docs.python.org/2/library/xml.etree.elementtree.html
		root = self.xml.getroot()
		
		#Find index of element containing tracks
		i = 0
		
		for child in root[0]:
			if child.text == "Tracks":
				tracksIndex = i+1
				break
			i += 1
		
				
		#Loop trough all songs
		i = 0
		for song in root[0][tracksIndex]:
			#Every second element is a track
			if i % 2 == 1:
				
				#Loop through metadata of the track and extract info
				j = 0
				
				albumArtist = None
				
				for tag in song:

					if tag.text == "Name":
						trackName = song[j+1].text
					
					elif tag.text == "Artist":
						artist = song[j+1].text
						
					elif tag.text == "Album Artist":
						albumArtist = song[j+1].text
						
					elif tag.text == "Album":
						album = song[j+1].text
						
					elif tag.text == "Genre":
						genre = song[j+1].text
						
					elif tag.text == "Year":
						year = song[j+1].text
					
					j += 1
				
				
				#Sometime Album Artist is not defined, then we take the artist as album artist
				if albumArtist == None:
					albumArtist = artist
				
				#Make new track
				try:
					track = Track(trackName, artist, albumArtist, album, year, genre)
				except:
					#Sometime Album Artist is not defined, then we take the artist as album artist
					track = Track(trackName, artist, artist, album, year, genre)
				
				#Add track to 'library'
				self.library.append(track)
			
			i += 1			
			
		
		return


	def getTrackList(self):
		'''Returns list with all tracks'''
		return self.library
		

	def __str__(self):
		'''Returns string of iTunes Library with all albums'''
		
		string = ""
		
		for i in range ( len(self.library) ):
			
			string += str(i+1)+". "
			
			string += str(self.library[i])
			
			if i != len(self.library) - 1:
				string += "\n"
		
		return string